/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: HostStateDlg.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 4.04.07 19:21 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Host State Get/Set Test dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        04.07.2006  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file HostStateDlg.cpp
///   Host State Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "HostStateDlg.h"
#include "CifXTestDlg.h"

#define DEFAULT_SETHOSTSTATE_TIMEOUT  0

/////////////////////////////////////////////////////////////////////////////
/// Host state elements for list control
/////////////////////////////////////////////////////////////////////////////
static struct HOST_STATEtag
{
  LPCTSTR       szState;  //!< State to display in control
  unsigned long ulState;  //!< State value for element
} s_atHostState[] =
{
  {_T("Application Ready"),     CIFX_HOST_STATE_READY},
  {_T("Application NOT Ready"), CIFX_HOST_STATE_NOT_READY},
};

IMPLEMENT_DYNAMIC(CHostStateDlg, CBaseDialog)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent Window
/////////////////////////////////////////////////////////////////////////////
CHostStateDlg::CHostStateDlg(CWnd* pParent /*=NULL*/)
	: CBaseDialog(CHostStateDlg::IDD, pParent, false)
  , m_ulSetTimeout(DEFAULT_SETHOSTSTATE_TIMEOUT)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CHostStateDlg::~CHostStateDlg()
{
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX 
/////////////////////////////////////////////////////////////////////////////
void CHostStateDlg::DoDataExchange(CDataExchange* pDX)
{
  CBaseDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_CB_NEWSTATE, m_cNewStateCtrl);
}


BEGIN_MESSAGE_MAP(CHostStateDlg, CBaseDialog)
  ON_BN_CLICKED(IDC_BTN_GETSTATE, OnBnClickedBtnGetstate)
  ON_BN_CLICKED(IDC_BTN_SETSTATE, OnBnClickedBtnSetstate)
  ON_EN_KILLFOCUS(IDC_EDT_TIMEOUT, OnEnKillfocusEdtTimeout)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
/// Button "Get Host State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CHostStateDlg::OnBnClickedBtnGetstate()
{
  uint32_t ulActState = 0;

  int32_t lRet = CcifXTestDlg::s_pcDevice->HostState(CIFX_HOST_STATE_READ, &ulActState, m_ulSetTimeout);

  CString csError;
  if(CIFX_NO_ERROR != lRet)
  {
    csError.Format(_T("0x%08X\r\n%s"),
                   lRet,
                   (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

  } else
  {
    CString csState;

    switch(ulActState)
    {
    case CIFX_HOST_STATE_READY:
      csState = _T("Application Ready");
      break;

    case CIFX_HOST_STATE_NOT_READY:
      csState = _T("Application NOT Ready");
      break;

    default:
      csState = _T("Illegal Application State");
      break;
    }

    SetDlgItemText(IDC_EDT_ACTSTATE, csState);
  }
  SetDlgItemText(IDC_LASTERR, csError);

}

/////////////////////////////////////////////////////////////////////////////
/// Button "Set Host State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CHostStateDlg::OnBnClickedBtnSetstate()
{
  int iItem = m_cNewStateCtrl.GetCurSel();
  ASSERT(-1 != iItem);

  CWaitCursor cWait;

  uint32_t ulNewState = (uint32_t)m_cNewStateCtrl.GetItemData(iItem);
  uint32_t ulTemp     = 0;

  int32_t lRet = CcifXTestDlg::s_pcDevice->HostState(ulNewState, &ulTemp, m_ulSetTimeout);

  CString csError;
  if(CIFX_NO_ERROR != lRet)
  {
    csError.Format(_T("0x%08X\r\n%s"),
                   lRet,
                   (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

  }
  SetDlgItemText(IDC_LASTERR, csError);
}

/////////////////////////////////////////////////////////////////////////////
/// Set Host State Timeout editing end event
/////////////////////////////////////////////////////////////////////////////
void CHostStateDlg::OnEnKillfocusEdtTimeout()
{
  CString csTemp;
  GetDlgItemText(IDC_EDT_TIMEOUT, csTemp);

  TCHAR* pszEnd = NULL;
  m_ulSetTimeout = _tcstoul(csTemp, &pszEnd, 10);

  csTemp.Format(_T("%u"), m_ulSetTimeout);
  SetDlgItemText(IDC_EDT_TIMEOUT, csTemp);
}

/////////////////////////////////////////////////////////////////////////////
/// First Time dialog initialization
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CHostStateDlg::OnInitDialog()
{
  CBaseDialog::OnInitDialog();

  SetDlgItemInt(IDC_EDT_TIMEOUT, m_ulSetTimeout, FALSE);

  for(int iIdx = 0; iIdx < sizeof(s_atHostState) / sizeof(s_atHostState[0]); ++iIdx)
  {
    int iItem = m_cNewStateCtrl.AddString(s_atHostState[iIdx].szState);
    m_cNewStateCtrl.SetItemData(iItem, s_atHostState[iIdx].ulState);
  }

  m_cNewStateCtrl.SetCurSel(0);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
/// Cyclic Function (unused)
/////////////////////////////////////////////////////////////////////////////
void CHostStateDlg::ThreadFunction()
{
  //not needed, as we have no cyclic actions to perform
}

/////////////////////////////////////////////////////////////////////////////
/// Device changed in Main Dialog
///   \param pcDevice new Device (NULL if device was closed)
/////////////////////////////////////////////////////////////////////////////
void CHostStateDlg::OnUpdateDevice(CCifXDeviceBase* pcDevice)
{
  if(NULL != pcDevice)
    OnBnClickedBtnGetstate();
}
